<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $__env->yieldContent('desc'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keyword'); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_info('name')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/apps.css?ver=1.0.0')); ?>">
<?php if(sys_settings('ui_theme_skin', 'default')!='default'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/skins/theme-'.sys_settings('ui_theme_skin').'.css?ver=1.0.0')); ?>">
<?php endif; ?>
<?php if(sys_settings('google_track_id')): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(sys_settings('google_track_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', "<?php echo e(sys_settings('google_track_id')); ?>");
    </script>
<?php endif; ?>
<?php if(sys_settings('header_code')): ?>
    <?php echo e(html_string(sys_settings('header_code'))); ?>

<?php endif; ?>
<?php

use App\Enums\UserRoles;
?>
</head>
<body class="nk-body npc-cryptlite bg-white<?php echo e(($admins) ? ' admin-logged' : ''); ?>">
<div class="nk-app-root">
    <div class="nk-main">
        <header class="header <?php echo e((gss('ui_page_skin', 'dark')=='dark') ? 'bg-gray-900' : 'bg-white border-bottom border-bottom-light '); ?>">
            <div class="header-main <?php echo e((gss('ui_page_skin', 'dark')=='dark') ? 'header-dark bg-gray-900 on-dark' : 'header-light bg-white on-light'); ?> is-sticky is-transparent">
                <div class="container header-container wide-lg">
                    <div class="header-wrap">

                        <?php echo e(site_branding('header', ['panel' => 'public', 'size' => 'md'])); ?>


                        <div class="header-toggle">
                            <button class="menu-toggler" data-target="main-hmenu">
                                <em class="menu-on icon ni ni-menu"></em>
                                <em class="menu-off icon ni ni-cross"></em>
                            </button>
                        </div>

                        <nav class="header-menu"  data-content="main-hmenu">
                            <ul class="menu-list ml-lg-auto">
                                <?php if(gss('front_page_enable', 'yes')=='yes'): ?>
                                <li class="menu-item"><a href="<?php echo e(url('/')); ?>" class="menu-link nav-link"><?php echo e(__("Home")); ?></a></li>
                                <?php elseif(!empty(gss('main_website'))): ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(gss('main_website')); ?>" target="_blank" class="menu-link nav-link">
                                        <span><?php echo e(__("Main Website")); ?></span>
                                        <em class="icon ni ni-external pl-1"></em>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if(gss('invest_page_enable', 'yes')=='yes'): ?>
                                <li class="menu-item"><a href="<?php echo e(route('investments')); ?>" class="menu-link nav-link"><?php echo e(__("Investment")); ?></a></li>
                                <?php endif; ?>
                                <?php echo Panel::navigation('mainnav'); ?>


                                <?php if(!auth()->check() && gss('signup_allow', 'enable') == 'enable'): ?>
                                <li class="menu-item"><a href="<?php echo e(route('auth.register.form')); ?>" class="menu-link nav-link"><?php echo e(__("Register")); ?></a></li>
                                <?php endif; ?>
                            </ul>

                            <?php if(auth()->check()): ?>
                            <ul class="nk-quick-nav ml-1">
                                <li class="dropdown user-dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                        <div class="user-toggle">
                                            <div class="user-avatar sm">
                                                <em class="icon ni ni-user-alt"></em>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-md dropdown-menu-right dropdown-menu-s1">
                                        <div class="dropdown-inner user-card-wrap bg-lighter d-none d-md-block">
                                            <div class="user-card">
                                                <div class="user-avatar">
                                                    <span><?php echo user_avatar(auth()->user()); ?></span>
                                                </div>
                                                <div class="user-info">
                                                    <span class="lead-text"><?php echo e(auth()->user()->display_name); ?></span>
                                                    <span class="sub-text"><?php echo e(auth()->user()->email); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="dropdown-inner">
                                            <ul class="link-list">
                                                <li><a href="<?php echo e((auth()->user()->role==UserRoles::USER) ? route('dashboard') : route('admin.dashboard')); ?>"><em class="icon ni ni-dashboard"></em><span><?php echo e(__('Go to Dashboard')); ?></span></a></li>
                                                <li><a href="<?php echo e((auth()->user()->role==UserRoles::USER) ? route('account.profile') : route('admin.profile.view')); ?>"><em class="icon ni ni-user-alt"></em><span><?php echo e(__('View Profile')); ?></span></a></li>
                                            </ul>
                                        </div>
                                        <div class="dropdown-inner">
                                            <ul class="link-list">
                                                <li>
                                                    <a href="<?php echo e(route('auth.logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                    <em class="icon ni ni-signout"></em><spean><?php echo e(__('Sign out')); ?></spean></a>
                                                </li>
                                            </ul>
                                            <form id="logout-form" action="<?php echo e(route('auth.logout')); ?>" method="POST" style="display: none;">
                                                <?php echo csrf_field(); ?>
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <?php else: ?>
                            <ul class="menu-btns">
                                <li>
                                    <a href="<?php echo e(route('auth.login.form')); ?>" class="btn btn-round btn-primary"><em class="icon ni ni-user-alt"></em> <span><?php echo e(__("Login")); ?></span></a>
                                </li>
                            </ul>
                            <?php endif; ?>
                        </nav>
                    </div>
                </div>
            </div>
        </header>

        <div class="nk-page-content bg-lighter">
            <?php if(is_route('welcome')): ?>
                <?php echo $__env->yieldContent('content'); ?>
            <?php else: ?>
            <section class="section section-lg section-page">
                <div class="container wide-lg">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </section>
            <?php endif; ?>
        </div>

        <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>

<?php echo $__env->yieldPushContent('modal'); ?>

<script src="<?php echo e(asset('/assets/js/bundle.js')); ?>"></script>
<script src="<?php echo e(asset('/assets/js/app.js')); ?>"></script>
<?php echo $__env->yieldPushContent('scripts'); ?>
<?php if(sys_settings('tawk_api_key')): ?>
<script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();(function(){var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];s1.async=true;s1.src="https://embed.tawk.to/<?php echo e(sys_settings('tawk_api_key')); ?>/default";s1.charset="UTF-8";s1.setAttribute("crossorigin","*");s0.parentNode.insertBefore(s1,s0);})();
</script>
<?php endif; ?>
<?php if(sys_settings('footer_code')): ?>
    <?php echo e(html_string(sys_settings('footer_code'))); ?>

<?php endif; ?>
</body>
</html>
<?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/frontend/layouts/master.blade.php ENDPATH**/ ?>