<?php $__env->startSection('title', 'Superadmin Register'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-bordered">
    <div class="card-inner card-inner-lg">
        <div class="nk-block-head">
            <div class="alert alert-dim alert-danger alert-icon mb-4">
                <em class="icon ni ni-user"></em> <?php echo e(__("Register super admin account with full privilege.")); ?>

            </div>
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?php echo e(__('Register Admin Account')); ?></h4>
                <div class="nk-block-des mt-2">
                    <p><?php echo e(__('Create an admin account to manage application.')); ?></p>
                </div>
            </div>
        </div>
        <?php echo $__env->make('auth.partials.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form action="<?php echo e(route('auth.register', ['setup' => 'admin'])); ?>" autocomplete="off" method="POST" class="form-validate is-alter" autocomplete="off">
            <div class="form-group">
                <label class="form-label" for="full-name"><?php echo e(__('Full Name')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <input type="text" id="full-name" name="name" value="<?php echo e(old('name')); ?>" class="form-control form-control-lg<?php echo e(($errors->has('name')) ? ' error' : ''); ?>" minlength="3" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 3])); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label" for="email-address"><?php echo e(__('Email Address')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <input type="email" id="email-address" name="email" value="<?php echo e(old('email')); ?>" class="form-control form-control-lg<?php echo e(($errors->has('email')) ? ' error' : ''); ?>" autocomplete="off" data-msg-email="<?php echo e(__('Enter a valid email.')); ?>" data-msg-required="<?php echo e(__('Required.')); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label" for="passcode"><?php echo e(__('Password')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <a tabindex="-1" href="#" class="form-icon form-icon-right passcode-switch" data-target="passcode">
                        <em class="passcode-icon icon-show icon ni ni-eye-off"></em>
                        <em class="passcode-icon icon-hide icon ni ni-eye"></em>
                    </a>
                    <input name="password" id="passcode" type="password" autocomplete="new-password" class="form-control form-control-lg" minlength="6" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="confirmation" value="on">
                <button class="btn btn-lg btn-primary btn-block"><?php echo e(__('Create Account')); ?></button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('auth.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\vendor\softnio\utility-services\src/Views/setup.blade.php ENDPATH**/ ?>